/** @file   StreamUtils.cpp
 * @brief   Implementation of StreamUtils class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:40 $
 * @author  Tomi Lamminsaari
 */

#include "StreamUtils.h"
#include "eng2dPrivateConstants.h"
#include "datatypes.h"

namespace eng2d {


///
/// Constants, datatypes and static methods
/// ============================================================================

/** Searches for given tag.
 */
int StreamUtils::SearchForTag( std::istream& aIn,
                               const std::string& aTag )
{
  while ( aIn.eof() == false ) {
    std::string tmp;
    aIn >> tmp;
    if ( tmp == "#" ) {
      aIn.ignore( 4096, KCharNewLine );
      
    } else if ( tmp == aTag ) {
      return KErrNone;
      
    }
  }
  return KErrNotFound;
}



/** Skips a comment line.
 */
 /*
void StreamUtils::skipCommentLine( std::istream& aIn )
{
  aIn.ignore( KMaxLineLength, KCharNewLine );
}
*/



///
/// Constructors, destructor and operators
/// ============================================================================

/** Default constructor.
 */
StreamUtils::StreamUtils()
{
}



/** Destructor.
 */
StreamUtils::~StreamUtils()
{
}



///
/// Methods inhertited from the base class(es)
/// ============================================================================




///
/// New public methods
/// ============================================================================




///
/// Getter methods
/// ============================================================================




///
/// Protected and private methods
/// ============================================================================


}
